/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.mixin.chat;

import com.mojang.blaze3d.vertex.PoseStack;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import net.creeperhost.minetogether.chat.ChatConstants;
import net.creeperhost.minetogether.chat.ChatStatistics;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.chat.MessageDropdownOption;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.FriendRequestScreen;
import net.creeperhost.minetogether.chat.ingame.MTChatComponent;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.chat.irc.IrcState;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.polylib.gui.DropdownButton;
import net.creeperhost.minetogether.polylib.gui.PreviewRenderer;
import net.creeperhost.minetogether.polylib.gui.RadioButton;
import net.creeperhost.minetogether.util.MessageFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
abstract class ChatScreenMixin
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private RadioButton vanillaChatButton;
    private RadioButton mtChatButton;
    private DropdownButton<MessageDropdownOption> dropdownButton;
    @Nullable
    private Message clickedMessage;
    @Shadow
    protected EditBox f_95573_;
    private Button newUserButton;
    private Button disableButton;
    private final PreviewRenderer previewRenderer = new PreviewRenderer(5, 5, 80, 60){

        @Override
        protected URL getUrlUnderMouse(int mouseX, int mouseY) {
            if (MineTogetherChat.getTarget() != ChatTarget.PUBLIC) {
                return null;
            }
            Style style = MineTogetherChat.publicChat.getStyleUnderMouse(mouseX, mouseY);
            if (style == null) {
                return null;
            }
            HoverEvent event = style.m_131186_();
            if (event == null || event.m_130820_() != MessageFormatter.SHOW_URL_PREVIEW) {
                return null;
            }
            Component value = (Component)event.m_130823_(MessageFormatter.SHOW_URL_PREVIEW);
            try {
                return new URL(value.getString());
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
    };

    protected ChatScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        Minecraft mc = Minecraft.m_91087_();
        if (!Config.instance().chatEnabled || mc.f_91066_.f_92062_) {
            return;
        }
        int cWidth = mc.f_91065_.m_93076_().m_93813_();
        int cHeight = mc.f_91065_.m_93076_().m_93814_();
        int x = Mth.m_14167_((float)cWidth) + 6;
        this.vanillaChatButton = new RadioButton(x, this.f_96544_ - 215, 12, 87, (Component)new TranslatableComponent("minetogether:ingame.chat.local")).withTextScale(0.75f).withVerticalText().onPressed(e -> MineTogetherChat.setTarget(ChatTarget.VANILLA));
        this.mtChatButton = new RadioButton(x, this.f_96544_ - 215 + 87, 12, 87, (Component)new TranslatableComponent("minetogether:ingame.chat.global")).withTextScale(0.75f).withVerticalText().onPressed(e -> MineTogetherChat.setTarget(ChatTarget.PUBLIC));
        this.m_142416_((GuiEventListener)this.vanillaChatButton);
        this.m_142416_((GuiEventListener)this.mtChatButton);
        this.dropdownButton = (DropdownButton)this.m_142416_((GuiEventListener)new DropdownButton<MessageDropdownOption>(100, 20, clicked -> {
            assert (this.clickedMessage != null);
            assert (this.clickedMessage.sender != null);
            switch (clicked) {
                case MUTE: {
                    this.clickedMessage.sender.mute();
                    break;
                }
                case ADD_FRIEND: {
                    this.f_96541_.m_91152_((Screen)new FriendRequestScreen(this, this.clickedMessage.sender, FriendRequestScreen.Type.REQUEST));
                    break;
                }
                case MENTION: {
                    Object val = this.f_95573_.m_94155_();
                    if (!((String)val).isEmpty() && ((String)val).charAt(((String)val).length() - 1) != ' ') {
                        val = (String)val + " ";
                    }
                    this.f_95573_.m_94144_((String)val + this.clickedMessage.sender.getDisplayName());
                    break;
                }
                default: {
                    LOGGER.info("Dropdown action not currently implemented! {}", clicked);
                }
            }
        }));
        this.dropdownButton.setEntries(MessageDropdownOption.VALUES);
        this.dropdownButton.setFlipped(true);
        this.vanillaChatButton.linkButtons(this.mtChatButton);
        this.mtChatButton.linkButtons(this.vanillaChatButton);
        switch (MineTogetherChat.getTarget()) {
            case VANILLA: {
                this.vanillaChatButton.setPressed(true);
                break;
            }
            case PUBLIC: {
                this.mtChatButton.setPressed(true);
            }
        }
        this.m_169394_(this.previewRenderer);
        this.newUserButton = (Button)this.m_7787_((GuiEventListener)new Button(6, this.f_96544_ - (cHeight + 80) / 2 + 45, cWidth - 2, 20, (Component)new TextComponent("Join " + ChatStatistics.onlineCount + " online users now!"), e -> MineTogetherChat.setNewUserResponded()));
        this.disableButton = (Button)this.m_7787_((GuiEventListener)new Button(6, this.f_96544_ - (cHeight + 80) / 2 + 70, cWidth - 2, 20, (Component)new TextComponent("Don't ask me again."), e -> {
            MineTogetherChat.disableChat();
            Config.instance().chatEnabled = false;
            Config.save();
            MineTogetherChat.setNewUserResponded();
            this.m_169413_();
        }));
        this.newUserButton.f_93624_ = false;
        this.disableButton.f_93624_ = false;
        if (MineTogetherChat.isNewUser() && MineTogetherChat.getTarget() == ChatTarget.PUBLIC) {
            ChatStatistics.pollStats();
            this.newUserButton.f_93624_ = true;
            this.disableButton.f_93624_ = true;
        }
        this.switchToVanillaIfCommand();
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.instance().chatEnabled || Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        if (this.dropdownButton.m_6375_(mouseX, mouseY, button)) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (MineTogetherChat.getTarget() == ChatTarget.PUBLIC && this.tryClickMTChat(MineTogetherChat.publicChat, mouseX, mouseY)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(PoseStack pStack, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        if (MineTogetherChat.getTarget() == ChatTarget.PUBLIC && MineTogetherChat.isNewUser()) {
            pStack.m_85836_();
            pStack.m_85837_(0.0, 0.0, 100.0);
            MTChatComponent chatComponent = MineTogetherChat.publicChat;
            Objects.requireNonNull(this.f_96541_.f_91062_);
            int y = this.f_96544_ - 43 - 9 * Math.max(Math.min(chatComponent.m_93797_().size(), chatComponent.m_93816_()), 20);
            ChatScreenMixin.m_93172_((PoseStack)pStack, (int)0, (int)y, (int)(chatComponent.m_93813_() + 6), (int)(chatComponent.m_93814_() + 10 + y), (int)-1728053248);
            ChatScreenMixin.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether:new_user.1"), (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2), (int)0xFFFFFF);
            ChatScreenMixin.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether:new_user.2"), (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2 + 10), (int)0xFFFFFF);
            ChatScreenMixin.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether:new_user.3"), (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2 + 20), (int)0xFFFFFF);
            ChatScreenMixin.m_93215_((PoseStack)pStack, (Font)this.f_96547_, (Component)new TranslatableComponent("minetogether:new_user.4", new Object[]{ChatStatistics.userCount}), (int)(chatComponent.m_93813_() / 2 + 3), (int)(this.f_96544_ - (chatComponent.m_93814_() + 80) / 2 + 30), (int)0xFFFFFF);
            this.newUserButton.m_6305_(pStack, mouseX, mouseY, partialTicks);
            this.disableButton.m_6305_(pStack, mouseX, mouseY, partialTicks);
            pStack.m_85849_();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        this.switchToVanillaIfCommand();
        if (MineTogetherChat.getTarget() == ChatTarget.VANILLA) {
            this.f_95573_.m_94186_(true);
            this.f_95573_.m_94167_("");
            return;
        }
        if (MineTogetherChat.isNewUser()) {
            this.newUserButton.f_93624_ = true;
            this.disableButton.f_93624_ = true;
            this.f_95573_.m_94178_(false);
            this.f_95573_.m_94186_(false);
            return;
        }
        IrcState state = MineTogetherChat.CHAT_STATE.ircClient.getState();
        if (state != IrcState.CONNECTED) {
            this.f_95573_.m_94178_(false);
            this.f_95573_.m_94186_(false);
            this.f_95573_.m_94167_(new TranslatableComponent(ChatConstants.STATE_SUGGESTION_LOOKUP.get((Object)state)).getString());
            return;
        }
        this.f_95573_.m_94186_(true);
        this.f_95573_.m_94167_("");
    }

    private boolean tryClickMTChat(MTChatComponent mtChat, double mouseX, double mouseY) {
        if (!mtChat.handleClick(mouseX, mouseY)) {
            return false;
        }
        Message message = mtChat.getClickedMessage();
        if (message == null) {
            return false;
        }
        this.clickedMessage = message;
        mtChat.clearClickedMessage();
        this.dropdownButton.openAt(mouseX, mouseY);
        return true;
    }

    @Redirect(method={"keyPressed"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/ChatScreen;sendMessage(Ljava/lang/String;)V", opcode=182))
    private void onSendMessage(ChatScreen instance, String s) {
        switch (MineTogetherChat.getTarget()) {
            case VANILLA: {
                instance.m_96615_(s);
                break;
            }
            case PUBLIC: {
                MineTogetherChat.publicChat.m_93783_(s);
            }
        }
    }

    private boolean switchToVanillaIfCommand() {
        if (MineTogetherChat.getTarget() == ChatTarget.VANILLA) {
            return false;
        }
        if (!this.f_95573_.m_94155_().startsWith("/")) {
            return false;
        }
        MineTogetherChat.setTarget(ChatTarget.VANILLA);
        this.vanillaChatButton.selectButton();
        return true;
    }
}

